IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CF_MiClub_Cliente_Hab]') 
                   and [type] = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_MiClub_Cliente_Hab 
END
GO

CREATE FUNCTION dbo.CF_MiClub_Cliente_Hab (@Id_Cliente INT, @Fecha DATETIME)
RETURNS INT	
AS
BEGIN

/*
Descripcin:Valida si clientes esta habiltado para subir la deuda
Fecha de creacin: 11/12/2018
Auto: GC
Retorno: Retorna cero cuando es habilitao
*/


DECLARE @Retorno 	SMALLINT,
		@Cli_Ref_CtaCte_Agrup INT

SET @Cli_Ref_CtaCte_Agrup = dbo.CF_xParam('Cli_Ref_CtaCte_Agrup')


IF @Cli_Ref_CtaCte_Agrup = 0
BEGIN
	SET @Retorno = ISNULL(
						(
							SELECT SUM(dbo.CF_Cbte_Cob_Permitir(C.Id_Trans, @Fecha))
							FROM Cbtes C, Cbtes_Tipos T
							WHERE C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
							AND C.Id_Cond_Pago <> 1
							AND C.Id_Estado_Cbte IN(1,4)
							AND C.Saldo <> 0
							AND C.Fecha < @Fecha + 1
							AND C.Id_Cliente = @Id_Cliente
							AND T.Compromete_Factura = 1
						)
					,0)
END
ELSE
BEGIN
	SET @Retorno = ISNULL(
						(
							SELECT SUM(dbo.CF_Cbte_Cob_Permitir(C.Id_Trans, @Fecha))
							FROM Cbtes C, Cbtes_Tipos T
							WHERE C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
							AND C.Id_Cond_Pago <> 1
							AND C.Id_Estado_Cbte IN(1,4)
							AND C.Saldo <> 0
							AND C.Fecha < @Fecha + 1
							AND (C.Id_Cliente = @Id_Cliente
							OR C.Id_Cliente IN (SELECT Id_Cliente FROM Clientes WHERE Id_Cliente_Ref = @Id_Cliente ))
							AND T.Compromete_Factura = 1
						)
					,0)
END
                  


/* Agregar resto de validaciones aca */


RETURN ISNULL(@Retorno,0);

END
       
  